# Touch — Merge Predicate (Pinned)

**Goal.** Decide when two spatial touches are perceived as **two** vs **one** at the hinge, and confirm the empirical boundary **s_emp = 2σ**.

## Rule (d_in)

1. **Local smoothing (no‑skip).** Apply a single 3‑tap smoother
   \[ s = [0.25,\ 0.5,\ 0.25] \]
   once to the raw touch line (or as many times as your instrument implies, but each application is one act and must respect no‑skip).
2. **Peak counting (merge detector).** Count local maxima after smoothing using strict inequality on neighbors. Two maxima ⇒ “two”; otherwise “one.”
3. **Spacing sweep.** For Gaussian touches of width σ, sweep center separation `s` and record the smallest `s` at which the count flips to “two” as \( s_{\text{emp}} \).

## Acceptance

- **Exact boundary:** \( s_{\text{emp}} = 2\,\sigma \) (within numerical tolerance of one sample).  
- **Monotonic in κ:** increasing blur κ must not reduce the count when spacing is fixed.  
- **Re-centering:** a ±1‑sample circular shift does not change the decision.

## Manifest fields

```jsonc
{
  "touch": {
    "merge_test": "3tap_smooth + peak_count",
    "sigma_values": [1,2,3],
    "kappa_values": [1.0,2.0,3.0],
    "s_emp": { "1": 2, "2": 4, "3": 6 },
    "recenter_ok": true
  }
}
```
